capture log close
clear all
macro drop _all
set more off
cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\Input substitution\Stata\1. NZ Data"
log using log/NZasset3, replace text

/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Opex Cost Function Development Program
Author:  Michael Cunningham
File:    NZasset2.do
Initial Date:    22-Oct-2022
Revised Date:	 01-May-2025

Purpose: Read NZZ data for capital, and selected components of AUC
		 for the period 2013 to 2018

--------------------------------------------------------------------------*/

tempfile nzasset2a nzasset2b

*------------------------------------------------------------------------

import excel using data/Electricity-distributors-information-disclosure-data-2019-2023.xlsx, ///
	sheet("Database") cellrange(A1:M397556) firstrow clear
describe

gen int eiid = 0
replace eiid = 2001 if EDB == "Vector Lines"
replace eiid = 2002 if EDB == "Powerco"
replace eiid = 2003 if EDB == "Unison Networks"
replace eiid = 2004 if EDB == "WEL Networks"
replace eiid = 2005 if EDB == "Aurora Energy"
replace eiid = 2006 if EDB == "Northpower"
replace eiid = 2007 if EDB == "Electra"
replace eiid = 2008 if EDB == "Network Tasman"
replace eiid = 2009 if EDB == "Counties Energy"
replace eiid = 2010 if EDB == "MainPower NZ"
replace eiid = 2011 if EDB == "The Power Company"
replace eiid = 2012 if EDB == "Top Energy"
replace eiid = 2013 if EDB == "Alpine Energy"
replace eiid = 2014 if EDB == "Eastland Network"
replace eiid = 2015 if EDB == "Horizon Energy"
replace eiid = 2016 if EDB == "Marlborough Lines"
replace eiid = 2017 if EDB == "The Lines Company"
replace eiid = 2018 if EDB == "Waipa Networks"
replace eiid = 2019 if EDB == "Wellington Electricity"
drop if eiid == 0
labmask eiid, values(EDB)

rename Observationyear year
 
gen varname = "."
	
replace varname = "VanillaWACC3" if Section == "2(i): Return on Investment" ///
	& Category == "ROI—comparable to a vanilla WACC" & Subcategory == ///
	"Estimate of vanilla WACC" & Description == "Mid-point estimate"	

replace varname = "tax" if Section == ///
	"5a(i): Regulatory Tax Allowance" & Category == ///
	"Regulatory tax allowance"  & Description == "Regulatory tax allowance"
	
replace varname = "infl" if Section == ///
	"4(i): Regulatory Asset Base Value (Rolled Forward)" & Category == ///
	"Total revaluations"	
	
replace varname = "depr" if Section == ///
	"4(i): Regulatory Asset Base Value (Rolled Forward)" & Category == ///
	"Total depreciation" & Description == "Total depreciation"	
	
replace varname = "dispo" if Section == ///
	"4(i): Regulatory Asset Base Value (Rolled Forward)" & Category == ///
	"Asset disposals" & Description == "Asset disposals"		
	
replace varname = "orab" if Section == ///
	"4(i): Regulatory Asset Base Value (Rolled Forward)" & Category == ///
	"Total opening RAB value" & Description == "Total opening RAB value"
	
replace varname = "crab" if Section == ///
	"4(i): Regulatory Asset Base Value (Rolled Forward)" & Category == ///
	"Total closing RAB value" & Description == "Total closing RAB value"	
	
replace varname = "CostDebt" if Schedule == "SCHEDULE 2: REPORT ON RETURN ON INVESTMENT" ///
	& Section == "2(ii): Information Supporting the ROI" & Category == ///
	"ROI—comparable to a post tax WACC" & Description == "Cost of debt assumption (%)"	

drop if varname == "."
*tab varname, m

keep eiid year varname Value
sort varname eiid year 
duplicates drop


local varlist1 VanillaWACC3 tax infl depr dispo orab crab CostDebt 	
foreach k of local varlist1 {
	drop if varname == "`k'" & eiid == eiid[_n-1] & year == year[_n-1]
}

sort eiid year varname 
reshape wide Value, i(eiid year) j(varname) string

foreach i of local varlist1 {
	rename Value`i' `i'
}
sort eiid year

*Creating the Straight Line Depreciation
replace depr = depr + infl

foreach i of varlist infl depr orab crab CostDebt {
	replace `i' = . if `i' == 0
}

gen NVWACC = VanillaWACC3
drop VanillaWACC3 

describe, f
summarize

export excel xlsx/nzasset3.xlsx, replace firstrow(var) 
save dta/nzasset3, replace
 
log close
exit
